﻿//****************************
//Register Namespace
//****************************

//Registers the ServiceCommunication namespace
Type.registerNamespace('ServiceCommunication');


//*****************************
//Create and Register Class
//*****************************

//SimpleWCFService constructor
ServiceCommunication.SimpleWCFService=function() {
    //initializes the Sys.Net.WebServiceProxy class
    ServiceCommunication.SimpleWCFService.initializeBase(this);
    this._timeout = 0;
    this._userContext = null;
    this._succeeded = null;
    this._failed = null;
    this._path = "/SimpleWCFService_InternalService.axd";
}

//SimpelService prototype
ServiceCommunication.SimpleWCFService.prototype={
     
    //Save customer method which calls the SaveCustomer method in the Http Handler
    saveCustomer:function(customer,succeededCallback, failedCallback, userContext) {
        /// <param name="customer" type="ServiceData.Simple.Customer">ServiceData.Simple.Customer</param>
        /// <param name="succeededCallback" type="Function" optional="true" mayBeNull="true"></param>
        /// <param name="failedCallback" type="Function" optional="true" mayBeNull="true"></param>
        /// <param name="userContext" optional="true" mayBeNull="true"></param>
        return this._invoke(this.get_path(), 'SaveCustomer',false,{customer:customer},succeededCallback,failedCallback,userContext); 
    },
    
    //Lookup customer method which calls the LookupCustomer method in the Http Handler
    lookupCustomer:function(customerId,succeededCallback, failedCallback, userContext) {
        /// <param name="customerId" type="string">System.String</param>
        /// <param name="succeededCallback" type="Function" optional="true" mayBeNull="true"></param>
        /// <param name="failedCallback" type="Function" optional="true" mayBeNull="true"></param>
        /// <param name="userContext" optional="true" mayBeNull="true"></param>
        return this._invoke(this.get_path(), 'LookupCustomer',false,{customerId:customerId},succeededCallback,failedCallback,userContext); 
    }

}

//Register the class with it's base class Sys.Net.WebServcieProxy
ServiceCommunication.SimpleWCFService.registerClass('ServiceCommunication.SimpleWCFService',Sys.Net.WebServiceProxy);


//********************
//Register Known Types
//********************

//Set gtc to generateTypeConstructor method
var gtc = Sys.Net.WebServiceProxy._generateTypedConstructor;

//Register data namespace
Type.registerNamespace('ServiceData.Simple');

//Register data types
if (typeof(ServiceData.Simple.Customer) === 'undefined') {
ServiceData.Simple.Customer=gtc("Customer:#ServiceData.Simple");
ServiceData.Simple.Customer.registerClass('ServiceData.Simple.Customer');
}




